<?php

use Illuminate\Support\Facades\Route;
use Inertia\Inertia;

Route::get('/', function () {
    return view('numerology');
})->name('home');

// Standalone Numerology App
Route::get('/numerology/{any?}', function () {
    return view('numerology');
})->where('any', '.*')->name('numerology');

Route::middleware(['auth', 'verified'])->group(function () {
    Route::get('dashboard', function () {
        return Inertia::render('dashboard');
    })->name('dashboard');
});

require __DIR__.'/settings.php';
require __DIR__.'/auth.php';
