import React from 'react';

const Footer: React.FC = () => {
  return (
    <footer className="bg-white shadow-lg mt-12">
      <div className="container mx-auto px-4 py-6">
        <div className="flex flex-col md:flex-row items-center justify-between">
          <div className="text-sm text-gray-600 mb-4 md:mb-0">
            © 2025 SWOT Talent Numerology Calculator. All rights reserved.
          </div>
          
          <div className="flex items-center space-x-6 text-sm text-gray-600">
            <a 
              href="#" 
              className="hover:text-purple-600 transition-colors duration-300"
            >
              Privacy Policy
            </a>
            <a 
              href="#" 
              className="hover:text-purple-600 transition-colors duration-300"
            >
              Terms of Service
            </a>
            <a 
              href="#" 
              className="hover:text-purple-600 transition-colors duration-300"
            >
              Contact
            </a>
          </div>
        </div>
      </div>
    </footer>
  );
};

export default Footer;