# SWOT Talent UAT Deployment Instructions

## Prerequisites
- PHP 8.2+ with required extensions (mbstring, xml, curl, zip, openssl, pdo_mysql)
- MySQL 5.7+ or MariaDB
- Composer (for dependency installation if needed)
- Access to cPanel File Manager

## Deployment Steps

### 1. Upload Files
1. Create a ZIP file of this entire deployment-package folder
2. Log into your cPanel at https://uat.swottalent.com/cpanel
3. Go to File Manager
4. Navigate to the root directory (usually public_html or www)
5. Upload and extract the ZIP file
6. Move all contents from the extracted deployment-package folder to the root directory

### 2. Configure Environment
1. Rename `.env.example` to `.env`
2. Edit the `.env` file with your production settings:
   ```
   APP_URL=https://uat.swottalent.com
   DB_DATABASE=your_database_name
   DB_USERNAME=your_database_username  
   DB_PASSWORD=your_database_password
   ```

### 3. Generate Application Key
Run this command in cPanel Terminal or SSH:
```bash
php artisan key:generate
```

### 4. Set Up Database
1. Create a MySQL database in cPanel
2. Run migrations:
```bash
php artisan migrate
```

### 5. Set Permissions
Ensure these directories are writable (755 or 775):
- storage/
- storage/logs/
- storage/framework/
- storage/framework/sessions/
- storage/framework/views/
- storage/framework/cache/
- bootstrap/cache/

### 6. Configure Web Server
The included `.htaccess` file should redirect all requests to the `public` folder.

### 7. Test the Application
- Visit: https://uat.swottalent.com/
- Visit: https://uat.swottalent.com/numerology

## Important Notes

### Security
- Ensure `.env` file is not publicly accessible
- Set `APP_DEBUG=false` in production
- Use strong database passwords
- Consider enabling HTTPS redirects

### Numerology App
- The numerology calculator is accessible at `/numerology`
- It's a standalone React app that works independently
- All calculations are handled by the Laravel API

### Database Schema
The application includes these tables:
- users (for user authentication)
- numerology_calculations (for storing calculation results)
- sessions (for session management)

### Troubleshooting
- Check storage/logs/laravel.log for errors
- Ensure PHP extensions are installed
- Verify database connection settings
- Check file permissions if getting 500 errors

### File Structure
```
root/
├── app/                 # Laravel application code
├── bootstrap/          # Bootstrap files
├── config/             # Configuration files
├── database/           # Migrations and models
├── public/             # Web root (contains index.php and assets)
├── resources/          # Views, assets, and React components
├── routes/             # Route definitions
├── storage/            # Logs and cache (needs write permissions)
├── vendor/             # Composer dependencies
├── .env                # Environment configuration
├── .htaccess           # Web server configuration
├── artisan             # Laravel command line tool
└── composer.json       # PHP dependencies
```

## Support
If you encounter issues during deployment, check:
1. PHP version compatibility (8.2+)
2. Required PHP extensions
3. Database connection
4. File permissions
5. Error logs in storage/logs/