import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition } from './../../../../../wayfinder'
/**
* @see \App\Http\Controllers\Api\UserController::getProfile
* @see app/Http/Controllers/Api/UserController.php:13
* @route '/api/profile'
*/
export const getProfile = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: getProfile.url(options),
    method: 'get',
})

getProfile.definition = {
    methods: ["get","head"],
    url: '/api/profile',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\Api\UserController::getProfile
* @see app/Http/Controllers/Api/UserController.php:13
* @route '/api/profile'
*/
getProfile.url = (options?: RouteQueryOptions) => {
    return getProfile.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\Api\UserController::getProfile
* @see app/Http/Controllers/Api/UserController.php:13
* @route '/api/profile'
*/
getProfile.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: getProfile.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\UserController::getProfile
* @see app/Http/Controllers/Api/UserController.php:13
* @route '/api/profile'
*/
getProfile.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: getProfile.url(options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\Api\UserController::getProfile
* @see app/Http/Controllers/Api/UserController.php:13
* @route '/api/profile'
*/
const getProfileForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: getProfile.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\UserController::getProfile
* @see app/Http/Controllers/Api/UserController.php:13
* @route '/api/profile'
*/
getProfileForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: getProfile.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\UserController::getProfile
* @see app/Http/Controllers/Api/UserController.php:13
* @route '/api/profile'
*/
getProfileForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: getProfile.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

getProfile.form = getProfileForm

/**
* @see \App\Http\Controllers\Api\UserController::updateProfile
* @see app/Http/Controllers/Api/UserController.php:36
* @route '/api/profile'
*/
export const updateProfile = (options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: updateProfile.url(options),
    method: 'put',
})

updateProfile.definition = {
    methods: ["put"],
    url: '/api/profile',
} satisfies RouteDefinition<["put"]>

/**
* @see \App\Http\Controllers\Api\UserController::updateProfile
* @see app/Http/Controllers/Api/UserController.php:36
* @route '/api/profile'
*/
updateProfile.url = (options?: RouteQueryOptions) => {
    return updateProfile.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\Api\UserController::updateProfile
* @see app/Http/Controllers/Api/UserController.php:36
* @route '/api/profile'
*/
updateProfile.put = (options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: updateProfile.url(options),
    method: 'put',
})

/**
* @see \App\Http\Controllers\Api\UserController::updateProfile
* @see app/Http/Controllers/Api/UserController.php:36
* @route '/api/profile'
*/
const updateProfileForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: updateProfile.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'PUT',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Api\UserController::updateProfile
* @see app/Http/Controllers/Api/UserController.php:36
* @route '/api/profile'
*/
updateProfileForm.put = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: updateProfile.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'PUT',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

updateProfile.form = updateProfileForm

const UserController = { getProfile, updateProfile }

export default UserController